<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		error_reporting(E_ALL);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	public function getContent()
	{
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

        if(!isset($_SESSION['language'])){
			$_SESSION['language'] = 'pl';
		}
		
		// if( isset($_POST) && !empty($_POST['search']) )
		// {
			// $word = $_POST['search'];
			// unset($_POST);
			// header('Location: szukaj,'.$word.'.html');
		// }

        $tpl->assign('langs',$_SESSION['language']);
		
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
		include_once 'files/class.files.php';
		include_once 'newsy/classAktualnosci.php';
		include_once 'gallery/classGalerie.php';
		include_once 'produkty/classProdukty.php';
		include_once 'kontakt/classKontakt.php';
		include_once 'seo/class.seo.php';
		include_once './inc/pagination.class.php';
		include_once 'language.php';
		
		$content = new Strony();
		$cat = new Kategorie();
		$news = new Aktualnosci();
		$gal = new Galerie();
		$file = new Files();
		$pg = new pagination;
		$seo = new Seo();
		$prod = new Produkty();
		$kontakt = new Kontakt();

		$tpl->assign('set',$this->getSettings());
		$tpl->assign('menu',$cat->getMenu(1));
		
		
		
		// $tpl->assign('cats',$cat->getMenu(3));

		// $tpl->assign('adres',$news->getWpis(8));
		
		// if(!isset($_GET['site'])){
			// $welcome = $news->getWpis(7);
			// $tpl->assign('welcome',$welcome);
			// $footer = $news->getWpis(9);
			// $tpl->assign('footer',$footer);
			
			// $newsy = $news->getNewNews();
			// $tpl->assign('newsy',$newsy);
			
			// $tpl->assign('include','startowa.tpl');
			// $seoArray = $seo->getSeo(0,21);

			// if(is_array($seoArray)){
				// $tpl->assign('seo',$seoArray);
			// }
		// }
		
		
					// print("<pre>");
					// print_r($seoArray);
					// print("--------------------------------------</pre>");

		if(isset($_GET['site'])){
			$strona=(int)$_GET['site'];
			 if(isset($_GET['id']))
			 $id 			=	(int)$_GET['id'];
			// if(isset($_GET['id2']))
			// $id2 			=	(int)$_GET['id2'];
			// if(isset($_GET['id3']))
			// $id3 			=	(int)$_GET['id3'];
			// if(isset($_GET['id4']))
			// $id4 			=	(int)$_GET['id4'];
			// if(isset($_GET['id5']))
			// $id5 			=	(int)$_GET['id5'];
			
			
			$podstrony=array();
			if(isset($_GET['id']))
			{
				$id_podstrony=(int)$_GET['id'];
				$podstrony['id1']=(int)$_GET['id'];
			}
			// if(isset($_GET['id2']))
			// {
				// $id_podstrony=(int)$_GET['id2'];
				// $podstrony['id2']=(int)$_GET['id2'];
			// }
			// if(isset($_GET['id3']))
			// {
				// $id_podstrony=(int)$_GET['id3'];
				// $podstrony['id3']=(int)$_GET['id3'];
			// }
			// if(isset($_GET['id4']))
			// {
				// $id_podstrony=(int)$_GET['id4'];
				// $podstrony['id4']=(int)$_GET['id4'];
			// }
			// if(isset($_GET['id5']))
			// {
				// $id_podstrony=(int)$_GET['id5'];
				// $podstrony['id5']=(int)$_GET['id5'];
			// }
			
			// if(isset($_GET['site']))
			// $strona 		=	(int)$_GET['site'];
			// if(isset($_GET['page']))
			// $page 		=	(int)$_GET['page'];
			// if(isset($_GET['it']))
			// $it			=	(int)$_GET['it'];
                        // if(isset($_GET['p']))
			// $p			=	(int)$_GET['p'];
                        // if(isset($_GET['y']))
			// $y			=	(int)$_GET['y'];
			// if(isset($_GET['q']))
			// $q			= addslashes ($_GET['q']);
			
			// if(!empty($id))
			// $path = $cat->getPath($id);
			// else
			// $path = $cat->getPath($strona);
			// sort($path);
			// $tpl->assign('path',$path);

                        // $seoArray	=	$seo->getSeo(0,$strona);

			// if(is_array($seoArray)){
				// $tpl->assign('seo',$seoArray);
			}
			else
				$strona=0;
			
			$tpl->assign('strona', $strona);
			
			switch($strona){
				case 1:		// Podstrony
					$category=$cat->getCatByURL($_GET['name']);
					if(count($category)>0)
					{
						$tpl->assign('tresc', reset($content->getContentCat($category['id'])));
					}
					// $tpl->assign('lewa', reset($content->getContentCat(20)));
					$tpl->assign('include','text.tpl');
				break;
				case 2:		// Galeria
					// $foty=$gal->getZdjeciaAll($id_podstrony);
					// print("<pre>");
					// print_r($id_podstrony);
					// print("\n--------------------------------------</pre>");
					// print("<pre>");
					// print_r($foty);
					// print("\n--------------------------------------</pre>");
					$tpl->assign('zdjecia', $gal->getZdjeciaAll($id_podstrony));
					$tpl->assign('kategoria', $id_podstrony);
					// $tpl->assign('lewa', reset($content->getContentCat(20)));
					$tpl->assign('include','galeria.tpl');
				break;
				case 3:		// Kontakt
					if(isset($_SESSION['ok']))
					{
						$tpl->assign('informacja', $_SESSION['ok']);
						unset($_SESSION['ok']);
					}
					if(isset($_SESSION['err']))
					{
						$tpl->assign('informacja', $_SESSION['err']);
					}
					unset($_SESSION['err']);
					unset($_SESSION['ok']);
					$tpl->assign('tresc', reset($content->getContentCat(20)));
					$tpl->assign('include','kontakt.tpl');
				break;
				case 4:		// Oferta
					// $oferty=$prod->getAllProdukty();
					// print("<pre>");
					// print_r($oferty);
					// print("\n--------------------------------------</pre>");
					$tpl->assign('oferty', $prod->getAllProdukty());
					$tpl->assign('include','oferta.tpl');
				break;
				default:
					// $zdjecie=$gal->getZdjeciaRand(18);
					// print("<pre>");
					// print_r($zdjecie);
					// print("\n--------------------------------------</pre>");
					$tpl->assign('zdjecie', reset($gal->getZdjeciaRand(18)));
					$tpl->assign('firma', reset($content->getContentCat(21)));
					$tpl->assign('kontakt', reset($content->getContentCat(20)));
					$tpl->assign('include','start.tpl');
				break;
				// case 666:
					// $requested_URI=explode('/', $_SERVER['HTTP_REFERER']);
					// if(strstr($requested_URI[count($requested_URI)-1], '.html'))
					// {
						// $reguested_file=str_replace('.html', '', $requested_URI[count($requested_URI)-1]);
						// $category=$cat->getCatByURL($reguested_file);
						// $requested_URI[count($requested_URI)-1]=$category['url_'.$_GET['lang']].'.html';
					// }
				    // switch($_GET['lang']){
				     	// case 'fr':
				      		// $_SESSION['language'] = 'fr';
				      		// break;
				     	// case 'de':
				      		// $_SESSION['language'] = 'de';
				      		// break;
				     	// case 'ru':
				     		// $_SESSION['language'] = 'ru';
				     		// break;
				     	// case 'en':
				     		// $_SESSION['language'] = 'en';
				     		// break;
				     	// default:
				      		// $_SESSION['language'] = 'pl';
				      		// break;
				    // }
                    // header('Location: '.implode('/', $requested_URI));
				// break;
			}/* end switch */
                        
		// }
                $tpl->display('index.tpl');
	}

	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}

        public static function usun_ogonki($str)
	{
		$trans = array(
						"Ą" => "a", "ą" => "a", "Ć" => "c", "ć" => "c", "Ę" => "e",
						"ę" => "e", "Ł" => "l", "ł" => "l", "Ó" => "o","ó" => "o",
						"Ń" => "n","ń" => "n","Ś" => "s","ś"=> "s","Ź" => "z",
						"ź"=> "z","Ż" => "z","ż" => "z","," => "");

		return strtr($str, $trans);
	}
}
?>