<?php
/**
 * Klasa do obsługi modułu seo.
 * Zarzadzanie plikiem robots.txt
 * @author Bartosz Strzała
 * @package Seo
 * @version 0.1
 */

class Seo
{
	const robots_file = '../robots.txt';
	const htaccess_file = '../.htaccess';
	const p = 11;

	
	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p='.self::p.'&a=1&f=1';
		$submenu[0]['tekst'] = 'Zmień zawartośc pliku robots.txt';
		
		$submenu[1]['link'] = '?p='.self::p.'&a=1&f=2';
		$submenu[1]['tekst'] = 'Zmień zawartośc pliku .htaccess';
		
		$submenu[2]['link'] = '?p='.self::p.'&a=3';
		$submenu[2]['tekst'] = 'Zmień meta tagi';
			
		$smarty->assign('submenu', $submenu);
		$smarty->assign('robots', nl2br(self::getContentRobots()));
		$smarty->assign('htaccess', nl2br(self::getContentRobots(self::htaccess_file)));
	}
	
	public static function getContentRobots($file_name = '../robots.txt')
	{
		try
		{
			if(!file_exists($file_name)) {
				throw new Exception('Brak pliku '.$file_name.'.');
			}
				
			if(!is_writable($file_name)) {
				throw new Exception('Plik '.$file_name.' nie ma nadanych uprawnień do zapisu.');
			}
				
			$file = fopen($file_name,'r');
				
			return fread($file, filesize($file_name));
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public static function setContentRobots($file_name = '../robots.txt')
	{
		try
		{
			if(!file_exists($file_name)) {
				throw new Exception('Brak pliku '.$file_name.'.');
			}
				
			if(!is_writable($file_name)) {
				throw new Exception('Plik '.$file_name.' nie ma nadanych uprawnień do zapisu.');
			}
				
			$file = fopen($file_name,'w+');
				
			fwrite($file,$_POST['plik']);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function form($file_name = '../robots.txt')
	{
		$akcja= 'edycja';
		$new = new generatorFormularzy('Robots','./index.php?p='.self::p.'&a=2','POST','', true);
		$new->poczatekForm();

		$robotstxt = self::getContentRobots($file_name);

		$new->textarea('Plik', 20, 80,'',!empty($robotstxt) ? $robotstxt : '');

		$new->text('<br />');

		$new->inupt('r', 'hidden',time(),'','',false);
		$new->inupt('file_name', 'hidden',$file_name,'','',false);

		$new->inupt('ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}
	
	/*public function formMeta($akcja='dodaj')
	{
		$sql = 'SELECT * FROM '.Index::dbPrefiks.'meta;';
		$db = Zend_Registry::get('db');
		
		$tab = $db->fetchRow($sql);
				
		$new = new generatorFormularzy('Meta tagi','./index.php?p='.self::p.'&a=4','POST','',true);
		$new->poczatekForm();
		$new->textarea('Tytul', 10, 80,'',!empty($tab['tytul']) ? stripslashes($tab['tytul']) : '');
		$new->text('<br /><br />');
		$new->textarea('Opis strony', 10, 80,'',!empty($tab['opis']) ? stripslashes($tab['opis']) : '');
		$new->text('<br /><br />');
		$new->textarea('Słowa kluczowe', 10, 80,'',!empty($tab['slowa']) ? stripslashes($tab['slowa']) : '');
		$new->text('<br /><br />');
		$new->inupt('ok', 'submit',ucfirst($akcja),'','searchbutton',false);

		$new->inupt('r', 'hidden',time(),'','',false);
		$new->inupt('akcja', 'hidden',$akcja,'','',false);
		$new->inupt('id', 'hidden',$_GET['nr'],'','',false);
		$new->koniecForm();
	}*?
         *
         */
        public function formMeta($akcja='dodaj')
	{
		$sql = 'SELECT * FROM '.Index::dbPrefiks.'meta;';
		$db = Zend_Registry::get('db');

		$tab = $db->fetchRow($sql);

		$new = new generatorFormularzy('Meta tagi','./index.php?p='.self::p.'&a=4','POST','',true);
		$new->poczatekForm();
		//$new->textarea('Tytul', 10, 80,'',!empty($tab['tytul']) ? stripslashes($tab['tytul']) : '');
		$new->textarea('Tytul', 10, 80,'',stripslashes($tab['tytul']),'textlong','tytul');
		$new->text('<br /><br />');
		//$new->textarea('Opis strony', 10, 80,'',!empty($tab['opis']) ? stripslashes($tab['opis']) : '');
		$new->textarea('Opis strony', 10, 80,'',stripslashes($tab['opis']),'textlong','opis_strony');
		$new->text('<br /><br />');
		//$new->textarea('Słowa kluczowe', 10, 80,'',!empty($tab['slowa']) ? stripslashes($tab['slowa']) : '');
		$new->textarea('Słowa kluczowe', 10, 80,'',stripslashes($tab['slowa']),'textlong','slowa_kluczowe');
		$new->text('<br /><br />');
		$new->inupt('ok','ok', 'submit',ucfirst($akcja),'','searchbutton',false);

		$new->inupt('r','r', 'hidden',time(),'','',false);
		$new->inupt('akcja','akcja', 'hidden',$akcja,'','',false);
		$new->inupt('id','id' ,'hidden',$_GET['nr'],'','',false);
		$new->koniecForm();
	}
	
	public function addMeta()
	{
		Zend_Loader::loadClass('Zend_Filter_StripTags');
		$filtr = new Zend_Filter_StripTags();
			
		if($_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
		$_SESSION['form'] = $_POST['r'];
			
		$data = array();
		$data['tytul'] = ucfirst($filtr->filter($_POST['tytul']));
		$data['slowa'] = $filtr->filter($_POST['slowa_kluczowe']);
		$data['opis'] =  $filtr->filter($_POST['opis_strony']);

		$db = Zend_Registry::get('db');

		$db->update(Index::dbPrefiks.'meta', $data,'id=1');

		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('komunikat', array('typ'=>'info','tekst'=>'Dane zostały zmienione'));
		$this->menu();
	}

	public function add()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');

			self::setContentRobots($_POST['file_name']);
			
			$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Plik '.$file_name.' został zmieniony.'));
			$this->menu();

		}
			
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	/**
	 * Funkcja czyszczaca nazwa z wszelich nie potrzebnych znakow.
	 *
	 * @param string $string
	 * @return string
	 */

	public static function clearName($string)
	{
		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/', 
	                            '/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
	                            '/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
	                            '/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
	                            '/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
	                            '/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
	                            'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
	                            'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
	                            'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
	                            'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
	                            'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );
	}
}
?>