<?php

require_once'./php/klasy/drzewko.php';

class Spec extends drzewko
{

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);

		$white = imagecolorallocate($dimg, 245, 245, 245);
		imagefill($dimg, 0, 0, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}

	public function addForm($tab=array(),$akcja='dodaj')
	{
		$new = new generatorFormularzy('Spec','./index.php?p=51&a=1','POST','enctype="multipart/form-data"', true);
		$new->poczatekForm();
		$new->divid('k-menu');
				$new->divclass('e-menu-btn');
					$new->input('ok','', 'submit',' ','','searchbutton',false);
            		$new->text('<span class="tip-span"><img src="image/tip.png" alt="" /> Dodaj tekst</span>');
				$new->divend();
				$new->divclass('e-menu-btn');
					$new->input('reset','', 'reset',' ','','searc1hbutton',false);
           			$new->text('<span class="tip-span1"><img src="image/tip.png" alt="" /> Cofnij zmiany</span>');
				$new->divend();
			$new->divend();

                $new->divclass('box-main');
                    $new->divclass('box-main-top');
                        $new->divclass('bmt-flag');
                            $new->text('<img src="images/pl.png" alt="" id="flag" />');
                        $new->divend();
                        $new->divclass('bmt-input');
                            $new->inupt('Tytuł','tytul_pl', 'text',$tab['nazwa_pl'],'','textlong');
                            $new->inupt('Zdjęcie','foto', 'file');
                        $new->divend();
                    $new->divend();
                    $new->divclass('box-main-middle');
                        $new->textarea('Treść', 20, 100,'',stripslashes($tab['tresc_pl']),'textlong','tresc_pl');
                    $new->divend();
                $new->divend();
                
                $new->divclass('box-main');
                    $new->divclass('box-main-top');
                        $new->divclass('bmt-flag');
                            $new->text('<img src="image/lang/en.png" alt="" id="flag" />');
                        $new->divend();
                        $new->divclass('bmt-input');
                            $new->inupt('Tytuł','tytul_en', 'text',$tab['nazwa_en'],'','textlong');
                        $new->divend();
                    $new->divend();
                    $new->divclass('box-main-middle');
                        $new->textarea('Treść', 20, 100,'',stripslashes($tab['tresc_en']),'textlong','tresc_en');
                    $new->divend();
                $new->divend();

                $new->divclass('box-main');
                    $new->divclass('box-main-top');
                        $new->divclass('bmt-flag');
                            $new->text('<img src="image/lang/fr.png" alt="" id="flag" />');
                        $new->divend();
                        $new->divclass('bmt-input');
                            $new->inupt('Tytuł','tytul_fr', 'text',$tab['nazwa_fr'],'','textlong');
                        $new->divend();
                    $new->divend();
                    $new->divclass('box-main-middle');
                        $new->textarea('Treść', 20, 100,'',stripslashes($tab['nazwa_fr']),'textlong','tresc_fr');
                    $new->divend();
                $new->divend();
                
                $new->divclass('box-main');
                    $new->divclass('box-main-top');
                        $new->divclass('bmt-flag');
                            $new->text('<img src="image/lang/ru.png" alt="" id="flag" />');
                        $new->divend();
                        $new->divclass('bmt-input');
                            $new->inupt('Tytuł','tytul_ru', 'text',$tab['tytul_ru'],'','textlong');
                        $new->divend();
                    $new->divend();
                    $new->divclass('box-main-middle');
                        $new->textarea('Treść', 20, 100,'',stripslashes($tab['tresc_ru']),'textlong','tresc_ru');
                    $new->divend();
                $new->divend();

                $new->inupt('r','r', 'hidden',date('Y-m-d-H-i-s'),'','',false);
                $new->inupt('cat','cat', 'hidden',$_GET['cat'],'','',false);
		$new->inupt('akcja','akcja', 'hidden',$akcja,'','',false);
                if(isset($_GET['nr'])) $new->inupt('id','id', 'hidden',$_GET['nr'],'','',false);
		$new->koniecForm();
	}

	public function addAction()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');
			Zend_Loader::loadClass('Zend_Filter_StripTags');
			$filtr = new Zend_Filter_StripTags();
            $db = Zend_Registry::get('db');

			if($_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
			$_SESSION['form'] = $_POST['r'];

			$data = array();

			$data['nazwa_pl'] = $filtr->filter($_POST['tytul_pl']);
            $data['nazwa_en'] = $filtr->filter($_POST['tytul_en']);
            $data['nazwa_fr'] = $filtr->filter($_POST['tytul_fr']);
            $data['nazwa_ru'] = $filtr->filter($_POST['tytul_ru']);
                        
            $data['tresc_pl'] = $_POST['tresc_pl'];
			$data['tresc_en'] = $_POST['tresc_en'];
			$data['tresc_fr'] = $_POST['tresc_fr'];
			$data['tresc_ru'] = $_POST['tresc_ru'];
			
			$data['widoczny'] = 1;
			
			/***************************************************************************/
                if( ((int)$_POST['id'] == 0) || (empty($_POST['id'])) )
                {
                    $sqls = 'SELECT * FROM '.Index::dbPrefiks.'special ORDER BY kolejnosc DESC LIMIT 1';
                    $rows = $db->fetchRow($sqls);

                    if( !empty($rows['kolejnosc']) )
                        $koll = $rows['kolejnosc'] + 1;
                    else
                        $koll = '1';

                    $data['kolejnosc'] = $koll;
                }
                /******************************************************************************/
			
			global $_FILES;
	
	        $tab = explode('.',$_FILES['foto']['name']);
			$NazwaPliku = $_FILES['foto']['name'];
			$RozmiarPliku = $_FILES['foto']['size'];
			$TymczasowaNazwaPliku = $_FILES['foto']['tmp_name'];
			$Blad = $_FILES['foto']['error'];
	
			if(is_uploaded_file($TymczasowaNazwaPliku))
			{
				$tab[1] = strtolower($tab[1]);
				if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='gif' && $tab[1]!='png')
				{
					$error = array();
					$error['typ'] = 'error';
					$error['tekst'] = '<img src="./images/nok.png" alt="" style="vertical-align:middle;width:30px;" /> Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
					$smarty->assign('komunikat',$error);
				}
				else
				{
					$nameOfFile = $NazwaPliku;
					$NazwaPliku = date('Ydmhi').Index::usun_ogonki(str_replace(" ", "_", $NazwaPliku));
					$NazwaPliku = Index::usun_ogonki(str_replace(")", "", $NazwaPliku));
					$NazwaPliku = Index::usun_ogonki(str_replace("(", "", $NazwaPliku));
					$katalog = '../galeria/spec/';
					$katalog_kat = $katalog.'min/';
	
					if(!is_dir($katalog))
					{
						mkdir($katalog);
						chmod($katalog,0777);
					}
					if(!is_dir($katalog_kat))
					{
						mkdir($katalog_kat);
						chmod($katalog_kat,0777);
					}
	
					if(move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku))
					{
						$this->cropImage($katalog.$NazwaPliku, $katalog_kat.$NazwaPliku,140,140);
	
						$file['name'] = $NazwaPliku;
						$file['path'] = $katalog;
	
						$data['foto'] = $NazwaPliku;
					}
					else
					{
						$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> '<img src="./images/nok.png" alt="" style="vertical-align:middle;width:30px;" />Wystąpił błąd1: '.$Blad));
					}
				}
			}

			if($_POST['akcja']=='dodaj')
			{
				$db->insert(Index::dbPrefiks.'special', $data);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Strona dodana prawidłowo.'));
				$this->menu();
			}
			else
			{
				$db->update(Index::dbPrefiks.'special',$data, 'id='.$_POST['id']);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Treść strony zmieniona prawidłowo.'));
				$this->menu();
			}
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function listaAdmin()
	{
		$smarty = Zend_Registry::get('smarty');
		try
		{
			$sql="SELECT *, nazwa_pl as nazwa FROM ".Index::dbPrefiks."special ORDER BY kolejnosc ASC";
			$configBaza = Zend_Registry::get('configBaza');

			$db = Zend_Registry::get('db');

			$result = $db->fetchAll($sql);
			$resultCount = count($result);

			$lista = array();

			for($count=0;$count<$resultCount;$count++)
			{
				$lista[$count] = $result[$count];
				$lista[$count]['path'] = $this->pathToNode($result[$count]['ac'], 2);
			}

			$smarty->assign('lista', $lista);

		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p=51&a=2';
		$submenu[0]['tekst'] = 'Dodaj nową specjalizację';

		$smarty->assign('submenu', $submenu);
		$this->listaAdmin();
	}

	public function usunAction()
	{
		if(!empty($_GET['nr']))
		{
			$id = (int)$_GET['nr'];
			try
			{
				$smarty = Zend_Registry::get('smarty');
				$configBaza = Zend_Registry::get('configBaza');
				$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
				Zend_Db_Table::setDefaultAdapter($db);
				$db->delete(''.Index::dbPrefiks.'special', 'id='.$id);

				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Czynność została wykonana poprawnie.'));
				$this->listaAdmin();
			}

			catch (Zend_Db_Adapter_Exception $e)
			{
				przechwyc_blad($e);
			}

			catch (Zend_Exception $e)
			{
				przechwyc_blad($e);
			}
		}
	}

	public function edycjaForm()
	{
		try
		{
			$sql="SELECT * FROM ".Index::dbPrefiks."special WHERE id=".(int)$_GET['nr'];

			$db = Zend_Registry::get('db');

			$result = $db->fetchRow($sql);

			$this->addForm($result, 'zapisz');
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			przechwyc_blad($e);
		}
	}
	function widAction(){
		$smarty = Zend_Registry::get('smarty');
		$sql="SELECT * FROM ".Index::dbPrefiks."special WHERE id=".(int)$_GET['nr'];
		$db = Zend_Registry::get('db');
		$result = $db->fetchRow($sql);

		switch($result['widoczny']){
			case 1:
				$wid = 0;
				break;
			case 0:
				$wid = 1;
				break;
		}
		$db->update(Index::dbPrefiks."special",array('widoczny'=>$wid),'id='.(int)$_GET['nr']);
		$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Akcja wykonana prawidłowo.'));
		$this->menu();
	}

}

?>